/*==========================================================================
* FNT8x8.C - Copyright (c) 1993-94 ATI Technologies Inc. All rights reserved*
*                                                                          *
* PGL function that returns a pointer to the 8x8 interal PGL font.         *
* ======================================================================== */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>

#include "..\inc\pgl.h"
#include "..\inc\pglglob.h"

//
// Bitmap data array for 8x8 font
//
//   Width in pixels     : 8
//   Height in pixels    : 8
//   Bytes per character : 8
//   Total size in bytes : 2048
//
unsigned char pgl_fontbitmap8x8[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x7e, 0x81, 0xa5, 0x81, 0xbd, 0x99, 0x81, 0x7e, 
    0x7c, 0xfe, 0xd6, 0xba, 0xc6, 0xfe, 0x7c, 0x00, 
    0xc6, 0xee, 0xfe, 0xfe, 0x7c, 0x38, 0x10, 0x00, 
    0x10, 0x38, 0x7c, 0xfe, 0x7c, 0x38, 0x10, 0x00, 
    0x10, 0x38, 0x10, 0xee, 0xee, 0x10, 0x38, 0x00, 
    0x38, 0x7c, 0xfe, 0xfe, 0x6c, 0x10, 0x38, 0x00, 
    0x00, 0x18, 0x3c, 0x7e, 0x3c, 0x18, 0x00, 0x00, 
    0xff, 0xe7, 0xc3, 0x81, 0xc3, 0xe7, 0xff, 0xff, 
    0x00, 0x18, 0x3c, 0x66, 0x66, 0x3c, 0x18, 0x00, 
    0xff, 0xe7, 0xc3, 0x99, 0x99, 0xc3, 0xe7, 0xff, 
    0x1e, 0x0e, 0x1e, 0x36, 0x78, 0xcc, 0xcc, 0x78, 
    0x7e, 0xc3, 0xc3, 0x7e, 0x18, 0x7e, 0x18, 0x18, 
    0x1e, 0x1a, 0x1e, 0x18, 0x18, 0x70, 0xf0, 0x60, 
    0x3e, 0x3e, 0x36, 0x36, 0xf6, 0x66, 0x1e, 0x0c, 
    0xdb, 0x3c, 0x66, 0xe7, 0x66, 0x3c, 0xdb, 0x00, 
    0x80, 0xc0, 0xf0, 0xf8, 0xf0, 0xc0, 0x80, 0x00, 
    0x02, 0x06, 0x1e, 0x3e, 0x1e, 0x06, 0x02, 0x00, 
    0x18, 0x3c, 0x7e, 0x18, 0x7e, 0x3c, 0x18, 0x00, 
    0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x66, 0x00, 
    0x7f, 0xdb, 0x7b, 0x3b, 0x1b, 0x1b, 0x1b, 0x00, 
    0x3c, 0x66, 0x38, 0x6c, 0x6c, 0x38, 0xcc, 0x78, 
    0x00, 0x00, 0x00, 0x00, 0xfe, 0xfe, 0xfe, 0x00, 
    0x18, 0x3c, 0x7e, 0x18, 0x7e, 0x3c, 0x18, 0x7e, 
    0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x00, 
    0x18, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x00, 
    0x00, 0x18, 0x1c, 0xfe, 0x1c, 0x18, 0x00, 0x00, 
    0x00, 0x30, 0x70, 0xfe, 0x70, 0x30, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 
    0x00, 0x24, 0x66, 0xff, 0x66, 0x24, 0x00, 0x00, 
    0x00, 0x10, 0x38, 0x7c, 0x7c, 0xfe, 0x00, 0x00, 
    0x00, 0xfe, 0x7c, 0x7c, 0x38, 0x10, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x18, 0x3c, 0x3c, 0x18, 0x18, 0x00, 0x18, 0x00, 
    0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x6c, 0x6c, 0xfe, 0x6c, 0xfe, 0x6c, 0x6c, 0x00, 
    0x18, 0x7e, 0xc0, 0x7c, 0x06, 0xfc, 0x18, 0x00, 
    0x00, 0xc6, 0x0c, 0x18, 0x30, 0x60, 0xc6, 0x00, 
    0x38, 0x6c, 0x38, 0x76, 0xcc, 0xcc, 0x76, 0x00, 
    0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x18, 0x30, 0x60, 0x60, 0x60, 0x30, 0x18, 0x00, 
    0x60, 0x30, 0x18, 0x18, 0x18, 0x30, 0x60, 0x00, 
    0x00, 0xee, 0x7c, 0xfe, 0x7c, 0xee, 0x00, 0x00, 
    0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x30, 0x00, 
    0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x00, 
    0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0x80, 0x00, 
    0x7c, 0xc6, 0xce, 0xde, 0xf6, 0xe6, 0x7c, 0x00, 
    0x18, 0x78, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x00, 
    0x7c, 0xc6, 0x0c, 0x18, 0x30, 0x66, 0xfe, 0x00, 
    0x7c, 0xc6, 0x06, 0x3c, 0x06, 0xc6, 0x7c, 0x00, 
    0x0c, 0x1c, 0x3c, 0x6c, 0xfe, 0x0c, 0x0c, 0x00, 
    0xfe, 0xc0, 0xfc, 0x06, 0x06, 0xc6, 0x7c, 0x00, 
    0x7c, 0xc6, 0xc0, 0xfc, 0xc6, 0xc6, 0x7c, 0x00, 
    0xfe, 0xc6, 0x06, 0x0c, 0x18, 0x18, 0x18, 0x00, 
    0x7c, 0xc6, 0xc6, 0x7c, 0xc6, 0xc6, 0x7c, 0x00, 
    0x7c, 0xc6, 0xc6, 0x7e, 0x06, 0xc6, 0x7c, 0x00, 
    0x00, 0x1c, 0x1c, 0x00, 0x00, 0x1c, 0x1c, 0x00, 
    0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x30, 
    0x0c, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0c, 0x00, 
    0x00, 0x00, 0xfe, 0x00, 0x00, 0xfe, 0x00, 0x00, 
    0x60, 0x30, 0x18, 0x0c, 0x18, 0x30, 0x60, 0x00, 
    0x7c, 0xc6, 0x06, 0x0c, 0x18, 0x00, 0x18, 0x00, 
    0x7c, 0xc6, 0xc6, 0xde, 0xdc, 0xc0, 0x7e, 0x00, 
    0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0x00, 
    0xfc, 0x66, 0x66, 0x7c, 0x66, 0x66, 0xfc, 0x00, 
    0x3c, 0x66, 0xc0, 0xc0, 0xc0, 0x66, 0x3c, 0x00, 
    0xf8, 0x6c, 0x66, 0x66, 0x66, 0x6c, 0xf8, 0x00, 
    0xfe, 0xc2, 0xc0, 0xf8, 0xc0, 0xc2, 0xfe, 0x00, 
    0xfe, 0x62, 0x60, 0x7c, 0x60, 0x60, 0xf0, 0x00, 
    0x7c, 0xc6, 0xc0, 0xc0, 0xde, 0xc6, 0x7c, 0x00, 
    0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 
    0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 
    0x3c, 0x18, 0x18, 0x18, 0xd8, 0xd8, 0x70, 0x00, 
    0xc6, 0xcc, 0xd8, 0xf0, 0xd8, 0xcc, 0xc6, 0x00, 
    0xf0, 0x60, 0x60, 0x60, 0x60, 0x62, 0xfe, 0x00, 
    0xc6, 0xee, 0xfe, 0xd6, 0xd6, 0xc6, 0xc6, 0x00, 
    0xc6, 0xe6, 0xe6, 0xf6, 0xde, 0xce, 0xc6, 0x00, 
    0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 
    0xfc, 0x66, 0x66, 0x7c, 0x60, 0x60, 0xf0, 0x00, 
    0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xd6, 0x7c, 0x06, 
    0xfc, 0xc6, 0xc6, 0xfc, 0xd8, 0xcc, 0xc6, 0x00, 
    0x7c, 0xc6, 0xc0, 0x7c, 0x06, 0xc6, 0x7c, 0x00, 
    0x7e, 0x5a, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 
    0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 
    0xc6, 0xc6, 0xc6, 0xc6, 0x6c, 0x38, 0x10, 0x00, 
    0xc6, 0xc6, 0xd6, 0xd6, 0xfe, 0xee, 0xc6, 0x00, 
    0xc6, 0x6c, 0x38, 0x38, 0x38, 0x6c, 0xc6, 0x00, 
    0x66, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x3c, 0x00, 
    0xfe, 0x86, 0x0c, 0x18, 0x30, 0x62, 0xfe, 0x00, 
    0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x00, 
    0xc0, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x02, 0x00, 
    0x7c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x7c, 0x00, 
    0x10, 0x38, 0x6c, 0xc6, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 
    0x30, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0x7e, 0x00, 
    0xe0, 0x60, 0x7c, 0x66, 0x66, 0x66, 0xfc, 0x00, 
    0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xc6, 0x7c, 0x00, 
    0x1c, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x7e, 0x00, 
    0x00, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0x7c, 0x00, 
    0x1c, 0x36, 0x30, 0xfc, 0x30, 0x30, 0x78, 0x00, 
    0x00, 0x00, 0x76, 0xce, 0xc6, 0x7e, 0x06, 0x7c, 
    0xe0, 0x60, 0x7c, 0x66, 0x66, 0x66, 0xe6, 0x00, 
    0x18, 0x00, 0x38, 0x18, 0x18, 0x18, 0x3c, 0x00, 
    0x0c, 0x00, 0x1c, 0x0c, 0x0c, 0x0c, 0xcc, 0x78, 
    0xe0, 0x60, 0x66, 0x6c, 0x78, 0x6c, 0xe6, 0x00, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1c, 0x00, 
    0x00, 0x00, 0x6c, 0xfe, 0xd6, 0xd6, 0xc6, 0x00, 
    0x00, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x00, 
    0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 
    0x00, 0x00, 0xdc, 0x66, 0x66, 0x7c, 0x60, 0xf0, 
    0x00, 0x00, 0x76, 0xcc, 0xcc, 0x7c, 0x0c, 0x1e, 
    0x00, 0x00, 0xdc, 0x66, 0x60, 0x60, 0xf0, 0x00, 
    0x00, 0x00, 0x7c, 0xc0, 0x7c, 0x06, 0x7c, 0x00, 
    0x30, 0x30, 0xfc, 0x30, 0x30, 0x36, 0x1c, 0x00, 
    0x00, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 
    0x00, 0x00, 0xc6, 0xc6, 0x6c, 0x38, 0x10, 0x00, 
    0x00, 0x00, 0xc6, 0xc6, 0xd6, 0xfe, 0x6c, 0x00, 
    0x00, 0x00, 0xc6, 0x6c, 0x38, 0x6c, 0xc6, 0x00, 
    0x00, 0x00, 0xc6, 0xc6, 0xce, 0x76, 0x06, 0x7c, 
    0x00, 0x00, 0xfc, 0x98, 0x30, 0x64, 0xfc, 0x00, 
    0x0e, 0x18, 0x18, 0x70, 0x18, 0x18, 0x0e, 0x00, 
    0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x00, 
    0x70, 0x18, 0x18, 0x0e, 0x18, 0x18, 0x70, 0x00, 
    0x76, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x10, 0x38, 0x38, 0x6c, 0x6c, 0xfe, 0x00, 
    0x3c, 0x66, 0xc0, 0x66, 0x3c, 0x18, 0xcc, 0x78, 
    0x00, 0xc6, 0x00, 0xc6, 0xc6, 0xce, 0x76, 0x00, 
    0x0e, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0x7c, 0x00, 
    0x7c, 0xc6, 0x78, 0x0c, 0x7c, 0xcc, 0x7e, 0x00, 
    0xc6, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0x7e, 0x00, 
    0xe0, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0x7e, 0x00, 
    0x38, 0x38, 0x78, 0x0c, 0x7c, 0xcc, 0x7e, 0x00, 
    0x00, 0x00, 0x7c, 0xc0, 0x7c, 0x18, 0x6c, 0x38, 
    0x7c, 0xc6, 0x7c, 0xc6, 0xfe, 0xc0, 0x7c, 0x00, 
    0xc6, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0x7c, 0x00, 
    0xe0, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0x7c, 0x00, 
    0x66, 0x00, 0x38, 0x18, 0x18, 0x18, 0x3c, 0x00, 
    0x7c, 0xc6, 0x38, 0x18, 0x18, 0x18, 0x3c, 0x00, 
    0xe0, 0x00, 0x38, 0x18, 0x18, 0x18, 0x3c, 0x00, 
    0xc6, 0x38, 0x6c, 0xc6, 0xfe, 0xc6, 0xc6, 0x00, 
    0x38, 0x38, 0x00, 0x7c, 0xc6, 0xfe, 0xc6, 0x00, 
    0x0e, 0x00, 0xfe, 0xc0, 0xf8, 0xc0, 0xfe, 0x00, 
    0x00, 0x00, 0x6c, 0x9a, 0x7e, 0xd8, 0x6e, 0x00, 
    0x7e, 0xd8, 0xd8, 0xfe, 0xd8, 0xd8, 0xde, 0x00, 
    0x7c, 0xc6, 0x00, 0x7c, 0xc6, 0xc6, 0x7c, 0x00, 
    0x00, 0xc6, 0x00, 0x7c, 0xc6, 0xc6, 0x7c, 0x00, 
    0x00, 0xe0, 0x00, 0x7c, 0xc6, 0xc6, 0x7c, 0x00, 
    0x7c, 0xc6, 0x00, 0xc6, 0xc6, 0xce, 0x76, 0x00, 
    0x00, 0xe0, 0x00, 0xc6, 0xc6, 0xce, 0x76, 0x00, 
    0x00, 0xc6, 0x00, 0xc6, 0xce, 0x76, 0x06, 0x7c, 
    0xc6, 0x38, 0x6c, 0xc6, 0xc6, 0x6c, 0x38, 0x00, 
    0xc6, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 
    0x00, 0x18, 0x7e, 0xd8, 0xd8, 0x7e, 0x18, 0x00, 
    0x38, 0x6c, 0x60, 0xf0, 0x66, 0xf6, 0x6c, 0x00, 
    0xc3, 0x66, 0x3c, 0x7e, 0x18, 0x3c, 0x18, 0x00, 
    0xfc, 0xc6, 0xfc, 0xcc, 0xde, 0xcc, 0xce, 0x00, 
    0x0c, 0x1e, 0x18, 0x7e, 0x18, 0x18, 0xd8, 0x70, 
    0x0e, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0x7e, 0x00, 
    0x1c, 0x00, 0x38, 0x18, 0x18, 0x18, 0x3c, 0x00, 
    0x00, 0x0e, 0x00, 0x7c, 0xc6, 0xc6, 0x7c, 0x00, 
    0x00, 0x0e, 0x00, 0xcc, 0xcc, 0xdc, 0x76, 0x00, 
    0x00, 0xfc, 0x00, 0xbc, 0x66, 0x66, 0xe6, 0x00, 
    0xfe, 0x00, 0xc6, 0xe6, 0xf6, 0xce, 0xc6, 0x00, 
    0x38, 0x6c, 0x3e, 0x00, 0x7e, 0x00, 0x00, 0x00, 
    0x7c, 0xc6, 0x7c, 0x00, 0x7c, 0x00, 0x00, 0x00, 
    0x18, 0x00, 0x18, 0x30, 0x60, 0x66, 0x3c, 0x00, 
    0x00, 0x00, 0x00, 0x7c, 0x60, 0x60, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x7c, 0x0c, 0x0c, 0x00, 0x00, 
    0xc0, 0xcc, 0xd8, 0x30, 0x7c, 0x36, 0x0c, 0x3e, 
    0xc0, 0xcc, 0xd8, 0x30, 0x6c, 0x3c, 0x7e, 0x0c, 
    0x18, 0x00, 0x18, 0x18, 0x3c, 0x3c, 0x18, 0x00, 
    0x00, 0x36, 0x6c, 0xd8, 0x6c, 0x36, 0x00, 0x00, 
    0x00, 0xd8, 0x6c, 0x36, 0x6c, 0xd8, 0x00, 0x00, 
    0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 
    0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 
    0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0xf8, 0x18, 0xf8, 0x18, 0x18, 0x18, 
    0x36, 0x36, 0x36, 0x36, 0xf6, 0x36, 0x36, 0x36, 
    0x00, 0x00, 0x00, 0x00, 0xfe, 0x36, 0x36, 0x36, 
    0x00, 0x00, 0xf8, 0x18, 0xf8, 0x18, 0x18, 0x18, 
    0x36, 0x36, 0xf6, 0x06, 0xf6, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 
    0x00, 0x00, 0xfe, 0x06, 0xf6, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0xf6, 0x06, 0xfe, 0x00, 0x00, 0x00, 
    0x36, 0x36, 0x36, 0x36, 0xfe, 0x00, 0x00, 0x00, 
    0x18, 0x18, 0xf8, 0x18, 0xf8, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xf8, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0x1f, 0x00, 0x00, 0x00, 
    0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x18, 0x18, 
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 
    0x18, 0x18, 0x18, 0x18, 0xff, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x1f, 0x18, 0x1f, 0x18, 0x18, 0x18, 
    0x36, 0x36, 0x36, 0x36, 0x37, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0x37, 0x30, 0x3f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x3f, 0x30, 0x37, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0xf7, 0x00, 0xff, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xff, 0x00, 0xf7, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0x37, 0x30, 0x37, 0x36, 0x36, 0x36, 
    0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 
    0x36, 0x36, 0xf7, 0x00, 0xf7, 0x36, 0x36, 0x36, 
    0x18, 0x18, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 
    0x36, 0x36, 0x36, 0x36, 0xff, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xff, 0x00, 0xff, 0x18, 0x18, 0x18, 
    0x00, 0x00, 0x00, 0x00, 0xff, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0x36, 0x36, 0x3f, 0x00, 0x00, 0x00, 
    0x18, 0x18, 0x1f, 0x18, 0x1f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x1f, 0x18, 0x1f, 0x18, 0x18, 0x18, 
    0x00, 0x00, 0x00, 0x00, 0x3f, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0x36, 0x36, 0xff, 0x36, 0x36, 0x36, 
    0x18, 0x18, 0xff, 0x18, 0xff, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0xf8, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x18, 0x18, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 
    0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x66, 0xdc, 0xd8, 0xdc, 0x66, 0x00, 
    0x00, 0x78, 0xcc, 0xf8, 0xcc, 0xc6, 0xcc, 0x00, 
    0x00, 0xfe, 0x62, 0x60, 0x60, 0x60, 0xe0, 0x00, 
    0x00, 0xfe, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x00, 
    0xfe, 0xc6, 0x60, 0x30, 0x60, 0xc6, 0xfe, 0x00, 
    0x00, 0x7e, 0xd8, 0xcc, 0xcc, 0xd8, 0x70, 0x00, 
    0x00, 0x66, 0x66, 0x66, 0x66, 0x7c, 0xc0, 0x00, 
    0x00, 0x76, 0xdc, 0x18, 0x18, 0x18, 0x38, 0x00, 
    0xfe, 0x38, 0x6c, 0xc6, 0x6c, 0x38, 0xfe, 0x00, 
    0x38, 0x6c, 0xc6, 0xfe, 0xc6, 0x6c, 0x38, 0x00, 
    0x38, 0x6c, 0xc6, 0xc6, 0x6c, 0x6c, 0xee, 0x00, 
    0x3e, 0x60, 0x38, 0x66, 0xc6, 0xcc, 0x78, 0x00, 
    0x00, 0x00, 0x7e, 0xdb, 0xdb, 0x7e, 0x00, 0x00, 
    0x06, 0x7c, 0xde, 0xf6, 0xe6, 0x7c, 0xc0, 0x00, 
    0x38, 0x60, 0xc0, 0xf8, 0xc0, 0x60, 0x38, 0x00, 
    0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 
    0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x00, 
    0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x7e, 0x00, 
    0x30, 0x18, 0x0c, 0x18, 0x30, 0x00, 0x7e, 0x00, 
    0x0c, 0x18, 0x30, 0x18, 0x0c, 0x00, 0x7e, 0x00, 
    0x0c, 0x1e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0x78, 0x30, 0x00, 
    0x00, 0x00, 0x18, 0x00, 0x7e, 0x00, 0x18, 0x00, 
    0x00, 0x76, 0xdc, 0x00, 0x76, 0xdc, 0x00, 0x00, 
    0x7c, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 
    0x1f, 0x18, 0x18, 0x18, 0xf8, 0x38, 0x18, 0x00, 
    0xd8, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00, 
    0x70, 0xd8, 0x30, 0xf8, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x7c, 0x7c, 0x7c, 0x7c, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

//
// Static PGL font structure for 8x8 font
//
PGL_font pgl_fixedfont8x8[] =
{
    8,  // character width
    8,  // character height
    {   // character index array

        0x0000, 0x0008, 0x0010, 0x0018, 0x0020, 0x0028, 0x0030, 0x0038,
        0x0040, 0x0048, 0x0050, 0x0058, 0x0060, 0x0068, 0x0070, 0x0078, 
        0x0080, 0x0088, 0x0090, 0x0098, 0x00a0, 0x00a8, 0x00b0, 0x00b8, 
        0x00c0, 0x00c8, 0x00d0, 0x00d8, 0x00e0, 0x00e8, 0x00f0, 0x00f8, 
        0x0100, 0x0108, 0x0110, 0x0118, 0x0120, 0x0128, 0x0130, 0x0138, 
        0x0140, 0x0148, 0x0150, 0x0158, 0x0160, 0x0168, 0x0170, 0x0178, 
        0x0180, 0x0188, 0x0190, 0x0198, 0x01a0, 0x01a8, 0x01b0, 0x01b8, 
        0x01c0, 0x01c8, 0x01d0, 0x01d8, 0x01e0, 0x01e8, 0x01f0, 0x01f8, 
        0x0200, 0x0208, 0x0210, 0x0218, 0x0220, 0x0228, 0x0230, 0x0238, 
        0x0240, 0x0248, 0x0250, 0x0258, 0x0260, 0x0268, 0x0270, 0x0278, 
        0x0280, 0x0288, 0x0290, 0x0298, 0x02a0, 0x02a8, 0x02b0, 0x02b8, 
        0x02c0, 0x02c8, 0x02d0, 0x02d8, 0x02e0, 0x02e8, 0x02f0, 0x02f8, 
        0x0300, 0x0308, 0x0310, 0x0318, 0x0320, 0x0328, 0x0330, 0x0338, 
        0x0340, 0x0348, 0x0350, 0x0358, 0x0360, 0x0368, 0x0370, 0x0378, 
        0x0380, 0x0388, 0x0390, 0x0398, 0x03a0, 0x03a8, 0x03b0, 0x03b8, 
        0x03c0, 0x03c8, 0x03d0, 0x03d8, 0x03e0, 0x03e8, 0x03f0, 0x03f8, 
        0x0400, 0x0408, 0x0410, 0x0418, 0x0420, 0x0428, 0x0430, 0x0438, 
        0x0440, 0x0448, 0x0450, 0x0458, 0x0460, 0x0468, 0x0470, 0x0478, 
        0x0480, 0x0488, 0x0490, 0x0498, 0x04a0, 0x04a8, 0x04b0, 0x04b8, 
        0x04c0, 0x04c8, 0x04d0, 0x04d8, 0x04e0, 0x04e8, 0x04f0, 0x04f8, 
        0x0500, 0x0508, 0x0510, 0x0518, 0x0520, 0x0528, 0x0530, 0x0538, 
        0x0540, 0x0548, 0x0550, 0x0558, 0x0560, 0x0568, 0x0570, 0x0578, 
        0x0580, 0x0588, 0x0590, 0x0598, 0x05a0, 0x05a8, 0x05b0, 0x05b8, 
        0x05c0, 0x05c8, 0x05d0, 0x05d8, 0x05e0, 0x05e8, 0x05f0, 0x05f8, 
        0x0600, 0x0608, 0x0610, 0x0618, 0x0620, 0x0628, 0x0630, 0x0638, 
        0x0640, 0x0648, 0x0650, 0x0658, 0x0660, 0x0668, 0x0670, 0x0678, 
        0x0680, 0x0688, 0x0690, 0x0698, 0x06a0, 0x06a8, 0x06b0, 0x06b8, 
        0x06c0, 0x06c8, 0x06d0, 0x06d8, 0x06e0, 0x06e8, 0x06f0, 0x06f8, 
        0x0700, 0x0708, 0x0710, 0x0718, 0x0720, 0x0728, 0x0730, 0x0738, 
        0x0740, 0x0748, 0x0750, 0x0758, 0x0760, 0x0768, 0x0770, 0x0778, 
        0x0780, 0x0788, 0x0790, 0x0798, 0x07a0, 0x07a8, 0x07b0, 0x07b8, 
        0x07c0, 0x07c8, 0x07d0, 0x07d8, 0x07e0, 0x07e8, 0x07f0, 0x07f8, 
    },
    pgl_fontbitmap8x8, // pointer to bitmap data array
    NULL               // reserved
};

/* --------------------------------------------------------------------------
  PGL_getfixedfont8x8 - returns a pointer to the PGL internal 8x8 font

  This function returns a "PGL_font" pointer to the PGL's internal 8x8 font
  structure. This function is useful if loading a font file is not desired as
  with PGL_loadfont(). It is also always available. It should be noted that
  using this function will add the static font structure to the size of the
  application. Since this function returns a pointer instead of filling a
  given PGL_font structure, the application must access the font structure
  elements using '->' (instead of '.' as with PGL_loadfont()).
-------------------------------------------------------------------------- */
PGL_font *PGL_getfixedfont8x8(void)
{
    return (pgl_fixedfont8x8);
}

